<?php
namespace LoftOcean\Elementor;
/**
 * Elementor Widget Divider
 */
class Widget_Divider extends \LoftOcean\Elementor_Widget_Base {
	/**
	 * Get widget name.
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return apply_filters( 'loftocean_elementor_widget_name', 'loftoceandivider', array( 'id' => 'divider' ) );
	}
	/**
	 * Get widget title.
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Divider', 'loftocean' );
	}
	/**
	 * Get widget icon.
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-divider';
	}
	/**
	 * Get widget categories.
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'loftocean-theme-category' );
	}
	/**
	 * Get widget keywords.
	 * Retrieve the list of keywords the widget belongs to.
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return array( 'divider' );
	}
	/**
	* Get JavaScript dependency to render this widget
	* @return array of script handler
	*/
	public function get_script_depends() {
		return array();
	}
	/**
	* Get style dependency to render this widget
	* @return array of style handler
	*/
	public function get_style_depends() {
		return array();
	}
	/**
	 * Register widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section( 'general_content_section', array(
			'label' => __( 'General', 'loftocean' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT
		) );
        $this->add_control( 'type', array(
			'label' => esc_html__( 'Divider Type', 'loftocean' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => array(
                '' => esc_html__( 'Simple', 'loftocean' ),
                'divider-grass' => esc_html__( 'Grass', 'loftocean' ),
                'divider-star' => esc_html__( 'Star', 'loftocean' )
            )
		) );
        $this->end_controls_section();

        $this->start_controls_section( 'style_section', array(
            'label' => esc_html__( 'Style', 'loftocean' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ) );
		$this->add_control( 'line_color', array(
			'label' => esc_html__( 'Line Color', 'loftocean' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '',
			'selectors' => array(
				'{{WRAPPER}} .cs-d-line' => 'color: {{VALUE}};',
			)
		) );
		$this->add_control( 'icon_color', array(
			'label' => esc_html__( 'Icon Color', 'loftocean' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '',
			'selectors' => array(
				'{{WRAPPER}} .cs-d-icon' => 'color: {{VALUE}};',
			)
		) );
		$this->end_controls_section();
	}
	/**
	* Written in PHP and used to generate the final HTML.
    * @access protected
	*/
	protected function render() {
        $settings = $this->get_settings_for_display();
        $has_icon = false;
		$this->add_render_attribute( 'wrapper', 'class', array( 'cs-divider' ) );
		if ( ! empty( $settings[ 'type' ] ) ) {
            $has_icon = true;
            $this->add_render_attribute( 'wrapper', 'class', $settings[ 'type' ] );
        } ?>

        <div <?php $this->print_render_attribute_string( 'wrapper' ); ?>><?php
            if ( $has_icon ) : ?>
                <div class="cs-d-icon icon-start"><?php
                if ( 'divider-grass' == $settings[ 'type' ] ) : ?>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 31.06 29.67">
                        <path d="M36.53,21.85,31.78,18s-7.5.83-9.68,16.39C22.1,34.34,25.7,21.66,36.53,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <path class="cls-1" d="M5.47,21.85,10.22,18s7.5.83,9.68,16.39C19.9,34.34,16.3,21.66,5.47,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <polygon class="cls-1" points="15.53 0 18.66 6.56 15.53 22.16 12.39 6.56 15.53 0"></polygon>
                    </svg><?php
                else : ?>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 130 126.23">
                        <defs></defs>
                        <path d="M298.08,414a2,2,0,0,0-2.17.23c-.32.26-7.71,6.53-8.69,15.78a2,2,0,0,0,1,1.92,2,2,0,0,0,1,.24,2,2,0,0,0,1.2-.4c7.68-6,8.7-15.44,8.74-15.84A2,2,0,0,0,298.08,414Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M315.76,414.67a2,2,0,0,0-2.16-.32,2,2,0,0,0-1.11,1.88c0,.41.63,10.08,7.47,16.39a2,2,0,0,0,1.33.52,2,2,0,0,0,.8-.17,2,2,0,0,0,1.16-1.83C323.07,421.43,316.06,414.94,315.76,414.67Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M341.65,405a23.64,23.64,0,0,0-13.91-4.23,22.5,22.5,0,0,0-3.74.28,2,2,0,0,0-.73,3.55,27.59,27.59,0,0,0,14,4.23,20.23,20.23,0,0,0,3.59-.31,2,2,0,0,0,.8-3.52Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M321.05,389.06a2,2,0,0,0,.59-.09c.39-.12,9.61-3.09,14-11.27a2,2,0,0,0-2.24-2.83c-9.37,2.57-13.93,11-14.12,11.31a2,2,0,0,0,1.73,2.88Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M306.46,362.15a1.94,1.94,0,0,0-1.82,1.16c-3.94,8.88-.34,17.72-.18,18.09a2,2,0,0,0,1.81,1.21h0a2,2,0,0,0,1.8-1.24c.16-.38,3.69-9.4.16-18A2,2,0,0,0,306.46,362.15Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M291.37,388.82a1.88,1.88,0,0,0,.57.09,2,2,0,0,0,1.73-2.9c-.2-.36-4.88-8.84-13.75-11.63a2,2,0,0,0-2.35,2.74C281.88,385.83,291,388.7,291.37,388.82Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M290.2,401.41a2,2,0,0,0-1.51-1.57,26.59,26.59,0,0,0-5.14-.46,24.16,24.16,0,0,0-12.64,3.3,2,2,0,0,0,.55,3.57,21.09,21.09,0,0,0,5.22.65h0a25.77,25.77,0,0,0,12.64-3.49A2,2,0,0,0,290.2,401.41Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M312.79,399.05a6.49,6.49,0,1,1-6.49-6.49A6.48,6.48,0,0,1,312.79,399.05Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M369.09,410.27h0a37.72,37.72,0,0,1-4.87-3.09c-5.86-4-14.73-10.16-24.48-12.29a35.39,35.39,0,0,0-7.46-.75,54.24,54.24,0,0,0-8.86.8,43.54,43.54,0,0,0,14.57-7.44c7.69-6.36,12.78-15.86,16.14-22.14a38.23,38.23,0,0,1,2.9-5h0a2.36,2.36,0,0,0,.63-.78,2.45,2.45,0,0,0-3.73-3,36.39,36.39,0,0,1-5.45,1.93c-6.8,2.11-17.09,5.3-24.79,11.66A40.45,40.45,0,0,0,315,380.61a40.62,40.62,0,0,0,2.53-13.32c0-10-4.08-20-6.79-26.55a39.07,39.07,0,0,1-2-5.38h0a2.45,2.45,0,1,0-4.9,0,36.48,36.48,0,0,1-2,5.42c-2.7,6.6-6.79,16.56-6.79,26.55a39.62,39.62,0,0,0,2.28,12.57,39.53,39.53,0,0,0-8.15-9.82c-7.64-6.42-17.89-9.7-24.68-11.87a39.67,39.67,0,0,1-5.4-1.95h0a2.38,2.38,0,0,0-.79-.44,2.44,2.44,0,0,0-2.39,4.17,36.28,36.28,0,0,1,2.88,5c3.31,6.31,8.31,15.85,15.95,22.28a38.7,38.7,0,0,0,9.88,5.85,43.73,43.73,0,0,0-6.21-.48,34.35,34.35,0,0,0-5.27.4c-9.86,1.59-19,7.2-25.13,10.91a36.47,36.47,0,0,1-5,2.82,2.42,2.42,0,0,0-1.8,1.33,2.45,2.45,0,0,0,.23,2.54,2.49,2.49,0,0,0,2.39,1,40.5,40.5,0,0,1,5.6,1.1c5.42,1.27,12.84,3,20.55,3a43.65,43.65,0,0,0,6.74-.5c9-1.45,16.78-6.87,21.93-10.47.82-.57,1.73-1.2,2.5-1.7a6.54,6.54,0,1,1,.4.47,45.48,45.48,0,0,0-.38,4.87c-.28,5.83-.7,14.64-4.51,21.66-4.24,7.82-12,14.2-17.2,18.47.73-6.7,1.85-16.67,6.09-24.5a30.74,30.74,0,0,1,3.75-5.33,2.45,2.45,0,0,0-3.71-3.2,35.51,35.51,0,0,0-4.35,6.2c-4.76,8.77-5.91,19.48-6.68,26.57a39,39,0,0,1-.83,5.68h0a2.35,2.35,0,0,0-.25.7,2.43,2.43,0,0,0,1.23,2.63,2.37,2.37,0,0,0,1.17.3,2.42,2.42,0,0,0,2.14-1.27,36.73,36.73,0,0,1,4.34-3.83c5.51-4.51,13.86-11.32,18.61-20.09,3.8-7,4.62-15.13,5-21.26,0,6.14.38,14.29,3.77,21.49,4.27,9,12.22,16.29,17.48,21.1a38.12,38.12,0,0,1,4.11,4.05l0,.09h0a2.49,2.49,0,0,0,2.16,1.27,2.46,2.46,0,0,0,2.21-3.49,35.71,35.71,0,0,1-.52-5.75c-.38-7.12-.94-17.87-5.2-26.9-2.58-5.46-6.69-9.92-10.6-13.46,4.33,3,9.59,6,15.48,7.29a45.82,45.82,0,0,0,9.72,1,101.35,101.35,0,0,0,17.66-1.94,45.55,45.55,0,0,1,5.51-.79h.2a2.45,2.45,0,0,0,1.1-4.78Zm-93.14.06a38.54,38.54,0,0,1-6,.44c-7,0-14-1.6-19.17-2.81,5.75-3.51,14.34-8.7,23.12-10.12a29.46,29.46,0,0,1,4.5-.34c6.44,0,12.73,1.86,17.34,3.24C291,404.08,283.79,409.07,276,410.33Zm2-26.86c-6.81-5.72-11.51-14.58-14.64-20.56,6.42,2.06,16,5.16,22.78,10.88,6.08,5.11,9.69,13.1,12.08,18.42C292.49,390.77,284,388.58,277.92,383.47Zm28.38,4.92c-2.53-5.26-6.32-13.16-6.32-21.1,0-8.9,3.77-18.2,6.32-24.44,2.56,6.24,6.32,15.54,6.32,24.44C312.62,375.23,308.84,383.13,306.3,388.39Zm20-13.74c6.1-6.48,15.22-10.66,21.36-13.45-2.41,6.29-6.05,15.64-12.16,22.12-5.44,5.78-13.62,8.93-19.07,11C318.22,388.77,320.89,380.43,326.33,374.65Zm-.74,50.42c3.8,8.05,4.37,18.07,4.72,24.8-5-4.55-12.35-11.35-16.15-19.39-3.4-7.18-3.35-16-3.3-21.78C315.4,412.37,322.2,417.9,325.59,425.07Zm19-12.2A40.52,40.52,0,0,1,336,412c-7.76-1.69-14.67-7.07-19.27-10.67A67.45,67.45,0,0,1,332.23,399a30.08,30.08,0,0,1,6.41.64c8.69,1.9,17,7.56,22.53,11.38A96.4,96.4,0,0,1,344.62,412.87Z" transform="translate(-240.97 -332.88)"></path>
                    </svg><?php
                endif; ?>
                </div><?php
            endif; ?>
            <div class="cs-d-line"></div><?php
            if ( $has_icon ) : ?>
                <div class="cs-d-icon icon-end"><?php
                if ( 'divider-grass' == $settings[ 'type' ] ) : ?>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 31.06 29.67">
                        <path d="M36.53,21.85,31.78,18s-7.5.83-9.68,16.39C22.1,34.34,25.7,21.66,36.53,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <path class="cls-1" d="M5.47,21.85,10.22,18s7.5.83,9.68,16.39C19.9,34.34,16.3,21.66,5.47,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <polygon class="cls-1" points="15.53 0 18.66 6.56 15.53 22.16 12.39 6.56 15.53 0"></polygon>
                    </svg><?php
                else : ?>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 130 126.23">
                        <defs></defs>
                        <path d="M298.08,414a2,2,0,0,0-2.17.23c-.32.26-7.71,6.53-8.69,15.78a2,2,0,0,0,1,1.92,2,2,0,0,0,1,.24,2,2,0,0,0,1.2-.4c7.68-6,8.7-15.44,8.74-15.84A2,2,0,0,0,298.08,414Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M315.76,414.67a2,2,0,0,0-2.16-.32,2,2,0,0,0-1.11,1.88c0,.41.63,10.08,7.47,16.39a2,2,0,0,0,1.33.52,2,2,0,0,0,.8-.17,2,2,0,0,0,1.16-1.83C323.07,421.43,316.06,414.94,315.76,414.67Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M341.65,405a23.64,23.64,0,0,0-13.91-4.23,22.5,22.5,0,0,0-3.74.28,2,2,0,0,0-.73,3.55,27.59,27.59,0,0,0,14,4.23,20.23,20.23,0,0,0,3.59-.31,2,2,0,0,0,.8-3.52Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M321.05,389.06a2,2,0,0,0,.59-.09c.39-.12,9.61-3.09,14-11.27a2,2,0,0,0-2.24-2.83c-9.37,2.57-13.93,11-14.12,11.31a2,2,0,0,0,1.73,2.88Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M306.46,362.15a1.94,1.94,0,0,0-1.82,1.16c-3.94,8.88-.34,17.72-.18,18.09a2,2,0,0,0,1.81,1.21h0a2,2,0,0,0,1.8-1.24c.16-.38,3.69-9.4.16-18A2,2,0,0,0,306.46,362.15Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M291.37,388.82a1.88,1.88,0,0,0,.57.09,2,2,0,0,0,1.73-2.9c-.2-.36-4.88-8.84-13.75-11.63a2,2,0,0,0-2.35,2.74C281.88,385.83,291,388.7,291.37,388.82Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M290.2,401.41a2,2,0,0,0-1.51-1.57,26.59,26.59,0,0,0-5.14-.46,24.16,24.16,0,0,0-12.64,3.3,2,2,0,0,0,.55,3.57,21.09,21.09,0,0,0,5.22.65h0a25.77,25.77,0,0,0,12.64-3.49A2,2,0,0,0,290.2,401.41Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M312.79,399.05a6.49,6.49,0,1,1-6.49-6.49A6.48,6.48,0,0,1,312.79,399.05Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M369.09,410.27h0a37.72,37.72,0,0,1-4.87-3.09c-5.86-4-14.73-10.16-24.48-12.29a35.39,35.39,0,0,0-7.46-.75,54.24,54.24,0,0,0-8.86.8,43.54,43.54,0,0,0,14.57-7.44c7.69-6.36,12.78-15.86,16.14-22.14a38.23,38.23,0,0,1,2.9-5h0a2.36,2.36,0,0,0,.63-.78,2.45,2.45,0,0,0-3.73-3,36.39,36.39,0,0,1-5.45,1.93c-6.8,2.11-17.09,5.3-24.79,11.66A40.45,40.45,0,0,0,315,380.61a40.62,40.62,0,0,0,2.53-13.32c0-10-4.08-20-6.79-26.55a39.07,39.07,0,0,1-2-5.38h0a2.45,2.45,0,1,0-4.9,0,36.48,36.48,0,0,1-2,5.42c-2.7,6.6-6.79,16.56-6.79,26.55a39.62,39.62,0,0,0,2.28,12.57,39.53,39.53,0,0,0-8.15-9.82c-7.64-6.42-17.89-9.7-24.68-11.87a39.67,39.67,0,0,1-5.4-1.95h0a2.38,2.38,0,0,0-.79-.44,2.44,2.44,0,0,0-2.39,4.17,36.28,36.28,0,0,1,2.88,5c3.31,6.31,8.31,15.85,15.95,22.28a38.7,38.7,0,0,0,9.88,5.85,43.73,43.73,0,0,0-6.21-.48,34.35,34.35,0,0,0-5.27.4c-9.86,1.59-19,7.2-25.13,10.91a36.47,36.47,0,0,1-5,2.82,2.42,2.42,0,0,0-1.8,1.33,2.45,2.45,0,0,0,.23,2.54,2.49,2.49,0,0,0,2.39,1,40.5,40.5,0,0,1,5.6,1.1c5.42,1.27,12.84,3,20.55,3a43.65,43.65,0,0,0,6.74-.5c9-1.45,16.78-6.87,21.93-10.47.82-.57,1.73-1.2,2.5-1.7a6.54,6.54,0,1,1,.4.47,45.48,45.48,0,0,0-.38,4.87c-.28,5.83-.7,14.64-4.51,21.66-4.24,7.82-12,14.2-17.2,18.47.73-6.7,1.85-16.67,6.09-24.5a30.74,30.74,0,0,1,3.75-5.33,2.45,2.45,0,0,0-3.71-3.2,35.51,35.51,0,0,0-4.35,6.2c-4.76,8.77-5.91,19.48-6.68,26.57a39,39,0,0,1-.83,5.68h0a2.35,2.35,0,0,0-.25.7,2.43,2.43,0,0,0,1.23,2.63,2.37,2.37,0,0,0,1.17.3,2.42,2.42,0,0,0,2.14-1.27,36.73,36.73,0,0,1,4.34-3.83c5.51-4.51,13.86-11.32,18.61-20.09,3.8-7,4.62-15.13,5-21.26,0,6.14.38,14.29,3.77,21.49,4.27,9,12.22,16.29,17.48,21.1a38.12,38.12,0,0,1,4.11,4.05l0,.09h0a2.49,2.49,0,0,0,2.16,1.27,2.46,2.46,0,0,0,2.21-3.49,35.71,35.71,0,0,1-.52-5.75c-.38-7.12-.94-17.87-5.2-26.9-2.58-5.46-6.69-9.92-10.6-13.46,4.33,3,9.59,6,15.48,7.29a45.82,45.82,0,0,0,9.72,1,101.35,101.35,0,0,0,17.66-1.94,45.55,45.55,0,0,1,5.51-.79h.2a2.45,2.45,0,0,0,1.1-4.78Zm-93.14.06a38.54,38.54,0,0,1-6,.44c-7,0-14-1.6-19.17-2.81,5.75-3.51,14.34-8.7,23.12-10.12a29.46,29.46,0,0,1,4.5-.34c6.44,0,12.73,1.86,17.34,3.24C291,404.08,283.79,409.07,276,410.33Zm2-26.86c-6.81-5.72-11.51-14.58-14.64-20.56,6.42,2.06,16,5.16,22.78,10.88,6.08,5.11,9.69,13.1,12.08,18.42C292.49,390.77,284,388.58,277.92,383.47Zm28.38,4.92c-2.53-5.26-6.32-13.16-6.32-21.1,0-8.9,3.77-18.2,6.32-24.44,2.56,6.24,6.32,15.54,6.32,24.44C312.62,375.23,308.84,383.13,306.3,388.39Zm20-13.74c6.1-6.48,15.22-10.66,21.36-13.45-2.41,6.29-6.05,15.64-12.16,22.12-5.44,5.78-13.62,8.93-19.07,11C318.22,388.77,320.89,380.43,326.33,374.65Zm-.74,50.42c3.8,8.05,4.37,18.07,4.72,24.8-5-4.55-12.35-11.35-16.15-19.39-3.4-7.18-3.35-16-3.3-21.78C315.4,412.37,322.2,417.9,325.59,425.07Zm19-12.2A40.52,40.52,0,0,1,336,412c-7.76-1.69-14.67-7.07-19.27-10.67A67.45,67.45,0,0,1,332.23,399a30.08,30.08,0,0,1,6.41.64c8.69,1.9,17,7.56,22.53,11.38A96.4,96.4,0,0,1,344.62,412.87Z" transform="translate(-240.97 -332.88)"></path>
                    </svg><?php
                endif; ?>
                </div><?php
            endif; ?>
        </div><?php
    }
    /**
	* Render button widget output in the editor.
	* Written as a Backbone JavaScript template and used to generate the live preview.
	* @access protected
	*/
	protected function content_template() { ?>
        <#
        var hasIcon = false;
        view.addRenderAttribute( 'wrapper', 'class', 'cs-divider' );
        if ( settings[ 'type' ] ) {
            hasIcon = true;
            view.addRenderAttribute( 'wrapper', 'class', settings[ 'type' ] );
        } #>

        <div {{{ view.getRenderAttributeString( 'wrapper' ) }}}><#
            if ( hasIcon ) { #>
                <div class="cs-d-icon icon-start"><#
                if ( 'divider-grass' == settings[ 'type' ] ) { #>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 31.06 29.67">
                        <path d="M36.53,21.85,31.78,18s-7.5.83-9.68,16.39C22.1,34.34,25.7,21.66,36.53,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <path class="cls-1" d="M5.47,21.85,10.22,18s7.5.83,9.68,16.39C19.9,34.34,16.3,21.66,5.47,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <polygon class="cls-1" points="15.53 0 18.66 6.56 15.53 22.16 12.39 6.56 15.53 0"></polygon>
                    </svg><#
                } else { #>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 130 126.23">
                        <defs></defs>
                        <path d="M298.08,414a2,2,0,0,0-2.17.23c-.32.26-7.71,6.53-8.69,15.78a2,2,0,0,0,1,1.92,2,2,0,0,0,1,.24,2,2,0,0,0,1.2-.4c7.68-6,8.7-15.44,8.74-15.84A2,2,0,0,0,298.08,414Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M315.76,414.67a2,2,0,0,0-2.16-.32,2,2,0,0,0-1.11,1.88c0,.41.63,10.08,7.47,16.39a2,2,0,0,0,1.33.52,2,2,0,0,0,.8-.17,2,2,0,0,0,1.16-1.83C323.07,421.43,316.06,414.94,315.76,414.67Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M341.65,405a23.64,23.64,0,0,0-13.91-4.23,22.5,22.5,0,0,0-3.74.28,2,2,0,0,0-.73,3.55,27.59,27.59,0,0,0,14,4.23,20.23,20.23,0,0,0,3.59-.31,2,2,0,0,0,.8-3.52Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M321.05,389.06a2,2,0,0,0,.59-.09c.39-.12,9.61-3.09,14-11.27a2,2,0,0,0-2.24-2.83c-9.37,2.57-13.93,11-14.12,11.31a2,2,0,0,0,1.73,2.88Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M306.46,362.15a1.94,1.94,0,0,0-1.82,1.16c-3.94,8.88-.34,17.72-.18,18.09a2,2,0,0,0,1.81,1.21h0a2,2,0,0,0,1.8-1.24c.16-.38,3.69-9.4.16-18A2,2,0,0,0,306.46,362.15Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M291.37,388.82a1.88,1.88,0,0,0,.57.09,2,2,0,0,0,1.73-2.9c-.2-.36-4.88-8.84-13.75-11.63a2,2,0,0,0-2.35,2.74C281.88,385.83,291,388.7,291.37,388.82Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M290.2,401.41a2,2,0,0,0-1.51-1.57,26.59,26.59,0,0,0-5.14-.46,24.16,24.16,0,0,0-12.64,3.3,2,2,0,0,0,.55,3.57,21.09,21.09,0,0,0,5.22.65h0a25.77,25.77,0,0,0,12.64-3.49A2,2,0,0,0,290.2,401.41Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M312.79,399.05a6.49,6.49,0,1,1-6.49-6.49A6.48,6.48,0,0,1,312.79,399.05Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M369.09,410.27h0a37.72,37.72,0,0,1-4.87-3.09c-5.86-4-14.73-10.16-24.48-12.29a35.39,35.39,0,0,0-7.46-.75,54.24,54.24,0,0,0-8.86.8,43.54,43.54,0,0,0,14.57-7.44c7.69-6.36,12.78-15.86,16.14-22.14a38.23,38.23,0,0,1,2.9-5h0a2.36,2.36,0,0,0,.63-.78,2.45,2.45,0,0,0-3.73-3,36.39,36.39,0,0,1-5.45,1.93c-6.8,2.11-17.09,5.3-24.79,11.66A40.45,40.45,0,0,0,315,380.61a40.62,40.62,0,0,0,2.53-13.32c0-10-4.08-20-6.79-26.55a39.07,39.07,0,0,1-2-5.38h0a2.45,2.45,0,1,0-4.9,0,36.48,36.48,0,0,1-2,5.42c-2.7,6.6-6.79,16.56-6.79,26.55a39.62,39.62,0,0,0,2.28,12.57,39.53,39.53,0,0,0-8.15-9.82c-7.64-6.42-17.89-9.7-24.68-11.87a39.67,39.67,0,0,1-5.4-1.95h0a2.38,2.38,0,0,0-.79-.44,2.44,2.44,0,0,0-2.39,4.17,36.28,36.28,0,0,1,2.88,5c3.31,6.31,8.31,15.85,15.95,22.28a38.7,38.7,0,0,0,9.88,5.85,43.73,43.73,0,0,0-6.21-.48,34.35,34.35,0,0,0-5.27.4c-9.86,1.59-19,7.2-25.13,10.91a36.47,36.47,0,0,1-5,2.82,2.42,2.42,0,0,0-1.8,1.33,2.45,2.45,0,0,0,.23,2.54,2.49,2.49,0,0,0,2.39,1,40.5,40.5,0,0,1,5.6,1.1c5.42,1.27,12.84,3,20.55,3a43.65,43.65,0,0,0,6.74-.5c9-1.45,16.78-6.87,21.93-10.47.82-.57,1.73-1.2,2.5-1.7a6.54,6.54,0,1,1,.4.47,45.48,45.48,0,0,0-.38,4.87c-.28,5.83-.7,14.64-4.51,21.66-4.24,7.82-12,14.2-17.2,18.47.73-6.7,1.85-16.67,6.09-24.5a30.74,30.74,0,0,1,3.75-5.33,2.45,2.45,0,0,0-3.71-3.2,35.51,35.51,0,0,0-4.35,6.2c-4.76,8.77-5.91,19.48-6.68,26.57a39,39,0,0,1-.83,5.68h0a2.35,2.35,0,0,0-.25.7,2.43,2.43,0,0,0,1.23,2.63,2.37,2.37,0,0,0,1.17.3,2.42,2.42,0,0,0,2.14-1.27,36.73,36.73,0,0,1,4.34-3.83c5.51-4.51,13.86-11.32,18.61-20.09,3.8-7,4.62-15.13,5-21.26,0,6.14.38,14.29,3.77,21.49,4.27,9,12.22,16.29,17.48,21.1a38.12,38.12,0,0,1,4.11,4.05l0,.09h0a2.49,2.49,0,0,0,2.16,1.27,2.46,2.46,0,0,0,2.21-3.49,35.71,35.71,0,0,1-.52-5.75c-.38-7.12-.94-17.87-5.2-26.9-2.58-5.46-6.69-9.92-10.6-13.46,4.33,3,9.59,6,15.48,7.29a45.82,45.82,0,0,0,9.72,1,101.35,101.35,0,0,0,17.66-1.94,45.55,45.55,0,0,1,5.51-.79h.2a2.45,2.45,0,0,0,1.1-4.78Zm-93.14.06a38.54,38.54,0,0,1-6,.44c-7,0-14-1.6-19.17-2.81,5.75-3.51,14.34-8.7,23.12-10.12a29.46,29.46,0,0,1,4.5-.34c6.44,0,12.73,1.86,17.34,3.24C291,404.08,283.79,409.07,276,410.33Zm2-26.86c-6.81-5.72-11.51-14.58-14.64-20.56,6.42,2.06,16,5.16,22.78,10.88,6.08,5.11,9.69,13.1,12.08,18.42C292.49,390.77,284,388.58,277.92,383.47Zm28.38,4.92c-2.53-5.26-6.32-13.16-6.32-21.1,0-8.9,3.77-18.2,6.32-24.44,2.56,6.24,6.32,15.54,6.32,24.44C312.62,375.23,308.84,383.13,306.3,388.39Zm20-13.74c6.1-6.48,15.22-10.66,21.36-13.45-2.41,6.29-6.05,15.64-12.16,22.12-5.44,5.78-13.62,8.93-19.07,11C318.22,388.77,320.89,380.43,326.33,374.65Zm-.74,50.42c3.8,8.05,4.37,18.07,4.72,24.8-5-4.55-12.35-11.35-16.15-19.39-3.4-7.18-3.35-16-3.3-21.78C315.4,412.37,322.2,417.9,325.59,425.07Zm19-12.2A40.52,40.52,0,0,1,336,412c-7.76-1.69-14.67-7.07-19.27-10.67A67.45,67.45,0,0,1,332.23,399a30.08,30.08,0,0,1,6.41.64c8.69,1.9,17,7.56,22.53,11.38A96.4,96.4,0,0,1,344.62,412.87Z" transform="translate(-240.97 -332.88)"></path>
                    </svg><#
                } #>
                </div><#
            } #>
            <div class="cs-d-line"></div><#
            if ( hasIcon ) { #>
                <div class="cs-d-icon icon-end"><#
                if ( 'divider-grass' == settings[ 'type' ] ) { #>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 31.06 29.67">
                        <path d="M36.53,21.85,31.78,18s-7.5.83-9.68,16.39C22.1,34.34,25.7,21.66,36.53,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <path class="cls-1" d="M5.47,21.85,10.22,18s7.5.83,9.68,16.39C19.9,34.34,16.3,21.66,5.47,21.85Z" transform="translate(-5.47 -4.66)"></path>
                        <polygon class="cls-1" points="15.53 0 18.66 6.56 15.53 22.16 12.39 6.56 15.53 0"></polygon>
                    </svg><#
                } else { #>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 130 126.23">
                        <defs></defs>
                        <path d="M298.08,414a2,2,0,0,0-2.17.23c-.32.26-7.71,6.53-8.69,15.78a2,2,0,0,0,1,1.92,2,2,0,0,0,1,.24,2,2,0,0,0,1.2-.4c7.68-6,8.7-15.44,8.74-15.84A2,2,0,0,0,298.08,414Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M315.76,414.67a2,2,0,0,0-2.16-.32,2,2,0,0,0-1.11,1.88c0,.41.63,10.08,7.47,16.39a2,2,0,0,0,1.33.52,2,2,0,0,0,.8-.17,2,2,0,0,0,1.16-1.83C323.07,421.43,316.06,414.94,315.76,414.67Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M341.65,405a23.64,23.64,0,0,0-13.91-4.23,22.5,22.5,0,0,0-3.74.28,2,2,0,0,0-.73,3.55,27.59,27.59,0,0,0,14,4.23,20.23,20.23,0,0,0,3.59-.31,2,2,0,0,0,.8-3.52Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M321.05,389.06a2,2,0,0,0,.59-.09c.39-.12,9.61-3.09,14-11.27a2,2,0,0,0-2.24-2.83c-9.37,2.57-13.93,11-14.12,11.31a2,2,0,0,0,1.73,2.88Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M306.46,362.15a1.94,1.94,0,0,0-1.82,1.16c-3.94,8.88-.34,17.72-.18,18.09a2,2,0,0,0,1.81,1.21h0a2,2,0,0,0,1.8-1.24c.16-.38,3.69-9.4.16-18A2,2,0,0,0,306.46,362.15Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M291.37,388.82a1.88,1.88,0,0,0,.57.09,2,2,0,0,0,1.73-2.9c-.2-.36-4.88-8.84-13.75-11.63a2,2,0,0,0-2.35,2.74C281.88,385.83,291,388.7,291.37,388.82Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M290.2,401.41a2,2,0,0,0-1.51-1.57,26.59,26.59,0,0,0-5.14-.46,24.16,24.16,0,0,0-12.64,3.3,2,2,0,0,0,.55,3.57,21.09,21.09,0,0,0,5.22.65h0a25.77,25.77,0,0,0,12.64-3.49A2,2,0,0,0,290.2,401.41Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M312.79,399.05a6.49,6.49,0,1,1-6.49-6.49A6.48,6.48,0,0,1,312.79,399.05Z" transform="translate(-240.97 -332.88)"></path>
                        <path class="cls-1" d="M369.09,410.27h0a37.72,37.72,0,0,1-4.87-3.09c-5.86-4-14.73-10.16-24.48-12.29a35.39,35.39,0,0,0-7.46-.75,54.24,54.24,0,0,0-8.86.8,43.54,43.54,0,0,0,14.57-7.44c7.69-6.36,12.78-15.86,16.14-22.14a38.23,38.23,0,0,1,2.9-5h0a2.36,2.36,0,0,0,.63-.78,2.45,2.45,0,0,0-3.73-3,36.39,36.39,0,0,1-5.45,1.93c-6.8,2.11-17.09,5.3-24.79,11.66A40.45,40.45,0,0,0,315,380.61a40.62,40.62,0,0,0,2.53-13.32c0-10-4.08-20-6.79-26.55a39.07,39.07,0,0,1-2-5.38h0a2.45,2.45,0,1,0-4.9,0,36.48,36.48,0,0,1-2,5.42c-2.7,6.6-6.79,16.56-6.79,26.55a39.62,39.62,0,0,0,2.28,12.57,39.53,39.53,0,0,0-8.15-9.82c-7.64-6.42-17.89-9.7-24.68-11.87a39.67,39.67,0,0,1-5.4-1.95h0a2.38,2.38,0,0,0-.79-.44,2.44,2.44,0,0,0-2.39,4.17,36.28,36.28,0,0,1,2.88,5c3.31,6.31,8.31,15.85,15.95,22.28a38.7,38.7,0,0,0,9.88,5.85,43.73,43.73,0,0,0-6.21-.48,34.35,34.35,0,0,0-5.27.4c-9.86,1.59-19,7.2-25.13,10.91a36.47,36.47,0,0,1-5,2.82,2.42,2.42,0,0,0-1.8,1.33,2.45,2.45,0,0,0,.23,2.54,2.49,2.49,0,0,0,2.39,1,40.5,40.5,0,0,1,5.6,1.1c5.42,1.27,12.84,3,20.55,3a43.65,43.65,0,0,0,6.74-.5c9-1.45,16.78-6.87,21.93-10.47.82-.57,1.73-1.2,2.5-1.7a6.54,6.54,0,1,1,.4.47,45.48,45.48,0,0,0-.38,4.87c-.28,5.83-.7,14.64-4.51,21.66-4.24,7.82-12,14.2-17.2,18.47.73-6.7,1.85-16.67,6.09-24.5a30.74,30.74,0,0,1,3.75-5.33,2.45,2.45,0,0,0-3.71-3.2,35.51,35.51,0,0,0-4.35,6.2c-4.76,8.77-5.91,19.48-6.68,26.57a39,39,0,0,1-.83,5.68h0a2.35,2.35,0,0,0-.25.7,2.43,2.43,0,0,0,1.23,2.63,2.37,2.37,0,0,0,1.17.3,2.42,2.42,0,0,0,2.14-1.27,36.73,36.73,0,0,1,4.34-3.83c5.51-4.51,13.86-11.32,18.61-20.09,3.8-7,4.62-15.13,5-21.26,0,6.14.38,14.29,3.77,21.49,4.27,9,12.22,16.29,17.48,21.1a38.12,38.12,0,0,1,4.11,4.05l0,.09h0a2.49,2.49,0,0,0,2.16,1.27,2.46,2.46,0,0,0,2.21-3.49,35.71,35.71,0,0,1-.52-5.75c-.38-7.12-.94-17.87-5.2-26.9-2.58-5.46-6.69-9.92-10.6-13.46,4.33,3,9.59,6,15.48,7.29a45.82,45.82,0,0,0,9.72,1,101.35,101.35,0,0,0,17.66-1.94,45.55,45.55,0,0,1,5.51-.79h.2a2.45,2.45,0,0,0,1.1-4.78Zm-93.14.06a38.54,38.54,0,0,1-6,.44c-7,0-14-1.6-19.17-2.81,5.75-3.51,14.34-8.7,23.12-10.12a29.46,29.46,0,0,1,4.5-.34c6.44,0,12.73,1.86,17.34,3.24C291,404.08,283.79,409.07,276,410.33Zm2-26.86c-6.81-5.72-11.51-14.58-14.64-20.56,6.42,2.06,16,5.16,22.78,10.88,6.08,5.11,9.69,13.1,12.08,18.42C292.49,390.77,284,388.58,277.92,383.47Zm28.38,4.92c-2.53-5.26-6.32-13.16-6.32-21.1,0-8.9,3.77-18.2,6.32-24.44,2.56,6.24,6.32,15.54,6.32,24.44C312.62,375.23,308.84,383.13,306.3,388.39Zm20-13.74c6.1-6.48,15.22-10.66,21.36-13.45-2.41,6.29-6.05,15.64-12.16,22.12-5.44,5.78-13.62,8.93-19.07,11C318.22,388.77,320.89,380.43,326.33,374.65Zm-.74,50.42c3.8,8.05,4.37,18.07,4.72,24.8-5-4.55-12.35-11.35-16.15-19.39-3.4-7.18-3.35-16-3.3-21.78C315.4,412.37,322.2,417.9,325.59,425.07Zm19-12.2A40.52,40.52,0,0,1,336,412c-7.76-1.69-14.67-7.07-19.27-10.67A67.45,67.45,0,0,1,332.23,399a30.08,30.08,0,0,1,6.41.64c8.69,1.9,17,7.56,22.53,11.38A96.4,96.4,0,0,1,344.62,412.87Z" transform="translate(-240.97 -332.88)"></path>
                    </svg><#
                } #>
                </div><#
            } #>
        </div><?php
	}
}
