<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Studio\V1\Flow\Engagement;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string sid
 * @property string accountSid
 * @property string flowSid
 * @property string engagementSid
 * @property string name
 * @property array context
 * @property string transitionedFrom
 * @property string transitionedTo
 * @property \DateTime dateCreated
 * @property \DateTime dateUpdated
 * @property string url
 * @property array links
 */
class StepInstance extends InstanceResource {
	protected $_stepContext = null;

	/**
	 * Initialize the StepInstance
	 *
	 * @param \Twilio\Version $version Version that contains the resource
	 * @param mixed[] $payload The response payload
	 * @param string $flowSid Flow Sid.
	 * @param string $engagementSid Engagement Sid.
	 * @param string $sid Step Sid.
	 *
	 * @return \Twilio\Rest\Studio\V1\Flow\Engagement\StepInstance
	 */
	public function __construct( Version $version, array $payload, $flowSid, $engagementSid, $sid = null ) {
		parent::__construct( $version );

		// Marshaled Properties
		$this->properties = array(
			'sid'              => Values::array_get( $payload, 'sid' ),
			'accountSid'       => Values::array_get( $payload, 'account_sid' ),
			'flowSid'          => Values::array_get( $payload, 'flow_sid' ),
			'engagementSid'    => Values::array_get( $payload, 'engagement_sid' ),
			'name'             => Values::array_get( $payload, 'name' ),
			'context'          => Values::array_get( $payload, 'context' ),
			'transitionedFrom' => Values::array_get( $payload, 'transitioned_from' ),
			'transitionedTo'   => Values::array_get( $payload, 'transitioned_to' ),
			'dateCreated'      => Deserialize::dateTime( Values::array_get( $payload, 'date_created' ) ),
			'dateUpdated'      => Deserialize::dateTime( Values::array_get( $payload, 'date_updated' ) ),
			'url'              => Values::array_get( $payload, 'url' ),
			'links'            => Values::array_get( $payload, 'links' ),
		);

		$this->solution = array(
			'flowSid'       => $flowSid,
			'engagementSid' => $engagementSid,
			'sid'           => $sid ?: $this->properties['sid'],
		);
	}

	/**
	 * Fetch a StepInstance
	 *
	 * @return StepInstance Fetched StepInstance
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function fetch() {
		return $this->proxy()->fetch();
	}

	/**
	 * Generate an instance context for the instance, the context is capable of
	 * performing various actions.  All instance actions are proxied to the context
	 *
	 * @return \Twilio\Rest\Studio\V1\Flow\Engagement\StepContext Context for this
	 *                                                            StepInstance
	 */
	protected function proxy() {
		if ( ! $this->context ) {
			$this->context = new StepContext(
				$this->version,
				$this->solution['flowSid'],
				$this->solution['engagementSid'],
				$this->solution['sid']
			);
		}

		return $this->context;
	}

	/**
	 * Magic getter to access properties
	 *
	 * @param string $name Property to access
	 *
	 * @return mixed The requested property
	 * @throws TwilioException For unknown properties
	 */
	public function __get( $name ) {
		if ( array_key_exists( $name, $this->properties ) ) {
			return $this->properties[ $name ];
		}

		if ( property_exists( $this, '_' . $name ) ) {
			$method = 'get' . ucfirst( $name );

			return $this->$method();
		}

		throw new TwilioException( 'Unknown property: ' . $name );
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$context = array();
		foreach ( $this->solution as $key => $value ) {
			$context[] = "$key=$value";
		}

		return '[Twilio.Studio.V1.StepInstance ' . implode( ' ', $context ) . ']';
	}

	/**
	 * Access the stepContext
	 *
	 * @return \Twilio\Rest\Studio\V1\Flow\Engagement\Step\StepContextList
	 */
	protected function getStepContext() {
		return $this->proxy()->stepContext;
	}
}