<?php
namespace YayMail;

defined( 'ABSPATH' ) || exit;
/**
 * I18n Logic
 */
class I18n {

	protected static $instance = null;

	public static function getInstance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
			self::$instance->doHooks();
		}

		return self::$instance;
	}

	private function doHooks() {}

	private function __construct() {}

	public static function loadPluginTextdomain() {
		if ( function_exists( 'determine_locale' ) ) {
			$locale = determine_locale();
		} else {
			$locale = is_admin() ? get_user_locale() : get_locale();
		}

		unload_textdomain( 'yaymail' );
		load_textdomain( 'yaymail', YAYMAIL_PLUGIN_PATH . '/i18n/languages/yaymail-' . $locale . '.mo' );

		load_plugin_textdomain(
			'yaymail',
			false,
			YAYMAIL_PLUGIN_URL . 'i18n/languages/'
		);
	}

	public static function jsTranslate() {
		return array(
			'ELEMENTS'                                     => __( 'ELEMENTS', 'yaymail' ),
			'SETTINGS'                                     => __( 'SETTINGS', 'yaymail' ),
			'WooCommerceEmailCustomizer'                   => __( 'WooCommerce Email Customizer', 'yaymail' ),
			'BACKGROUNDCOLOR'                              => __( 'BACKGROUND COLOR', 'yaymail' ),
			'SelectColor'                                  => __( 'Select Color', 'yaymail' ),
			'Basic'                                        => __( 'Basic', 'yaymail' ),
			'General'                                      => __( 'General', 'yaymail' ),
			'WooCommerce'                                  => __( 'WooCommerce', 'yaymail' ),
			'DIRECTIONRTL'                                 => __( 'DIRECTION RTL', 'yaymail' ),
			'CONTAINERWIDTHPX'                             => __( 'CONTAINER WIDTH (PX)', 'yaymail' ),
			'Emailwidthmustbe'                             => __( 'Email width must be 480px (min) - 900px (max)', 'yaymail' ),
			'Pleaseinputcontainerwidth'                    => __( 'Please input container width!', 'yaymail' ),
			'DISPLAYPAYMENTINSTRUCTIONANDDETAILS'          => __( 'DISPLAY PAYMENT INSTRUCTION AND DETAILS', 'yaymail' ),
			'Yes'                                          => __( 'Yes', 'yaymail' ),
			'No'                                           => __( 'No', 'yaymail' ),
			'Onlyforcustomer'                              => __( 'Only for customer', 'yaymail' ),
			'SHOWPRODUCTIMAGE'                             => __( 'SHOW PRODUCT IMAGE', 'yaymail' ),
			'PRODUCTIMAGEPOSITION'                         => __( 'PRODUCT IMAGE POSITION', 'yaymail' ),
			'IMAGESIZE'                                    => __( 'IMAGE SIZE', 'yaymail' ),
			'Thumbnail'                                    => __( 'Thumbnail', 'yaymail' ),
			'Full'                                         => __( 'Full', 'yaymail' ),
			'IMAGEHEIGHT'                                  => __( 'IMAGE HEIGHT (PX)', 'yaymail' ),
			'Imageheightmustbe'                            => __( 'Image height must be 30px (min) - 300px (max)', 'yaymail' ),
			'Pleaseinputimgageheight'                      => __( 'Please input imgage height!', 'yaymail' ),
			'IMAGEWIDTH'                                   => __( 'IMAGE WIDTH (PX)', 'yaymail' ),
			'Imagewidthmustbe'                             => __( 'Image width must be 30px (min) - 300px (max)', 'yaymail' ),
			'Pleaseinputimgagewidth'                       => __( 'Please input imgage width!', 'yaymail' ),
			'SHOWPRODUCTSKU'                               => __( 'SHOW PRODUCT SKU', 'yaymail' ),
			'SHOWPRODUCTDESCRIPTION'                       => __( 'SHOW PRODUCT DESCRIPTION', 'yaymail' ),
			'SHOWPRODUCTHYPERLINKS'                        => __( 'SHOW PRODUCT HYPERLINKS', 'yaymail' ),
			'SHOWPRODUCTREGULARPRICE'                      => __( 'SHOW PRODUCT REGULAR PRICE', 'yaymail' ),
			'SHOWPRODUCTITEMCOST'                          => __( 'SHOW PRODUCT ITEM COST', 'yaymail' ),
			'CUSTOMCSS'                                    => __( 'CUSTOM CSS', 'yaymail' ),
			'Refresh'                                      => __( 'Refresh', 'yaymail' ),
			'Cancel'                                       => __( 'Cancel', 'yaymail' ),
			'Changeemailsubjectandformname'                => __( 'Change email subject and form name', 'yaymail' ),
			'Clickhere'                                    => __( 'Click here', 'yaymail' ),
			'Pleasecheckagain'                             => __( 'Please check again', 'yaymail' ),
			'Save'                                         => __( 'Save', 'yaymail' ),
			'PleaserefreshpagetoapplyCustomCSS'            => __( 'Please refresh page to apply Custom CSS. Make sure to save your changes before refreshing.', 'yaymail' ),
			'EmailSettings'                                => __( 'Email Settings', 'yaymail' ),
			'EMAILCONTENTBACKGROUNDCOLOR'                  => __( 'EMAIL CONTENT BACKGROUND COLOR', 'yaymail' ),
			'ResetDefault'                                 => __( 'Reset default', 'yaymail' ),
			'TEXTLINKCOLOR'                                => __( 'TEXT LINK COLOR', 'yaymail' ),
			'EnableDisableTemplates'                       => __( 'Enable/Disable Templates', 'yaymail' ),
			'ResetTemplates'                               => __( 'Reset Templates', 'yaymail' ),
			'ResetTemplate'                                => __( 'Reset template', 'yaymail' ),
			'RESETALLTEMPLATESTODEFAULT'                   => __( 'RESET ALL TEMPLATES TO DEFAULT', 'yaymail' ),
			'Reset'                                        => __( 'Reset', 'yaymail' ),
			'Yessure'                                      => __( 'Yes, sure!', 'yaymail' ),
			'Allyoursavedtemplatewillberesettodefault'     => __( 'All your saved template will be reset to default', 'yaymail' ),
			'ImportExportTemplates'                        => __( 'Import/Export Templates', 'yaymail' ),
			'EXPORT'                                       => __( 'EXPORT', 'yaymail' ),
			'ExportTemplates'                              => __( 'Export Templates', 'yaymail' ),
			'IMPORTTEMPLATES'                              => __( 'IMPORT TEMPLATES', 'yaymail' ),
			'ChooseFile'                                   => __( 'Choose File', 'yaymail' ),
			'Import'                                       => __( 'Import', 'yaymail' ),
			'Nofilechosen'                                 => __( 'No file chosen', 'yaymail' ),
			'BACKTOWORDPRESS'                              => __( 'BACK TO DASHBOARD', 'yaymail' ),
			'Sampleordertoshow'                            => __( 'Sample order to show', 'yaymail' ),
			'Shortcodes'                                   => __( 'Shortcodes', 'yaymail' ),
			'generals'                                     => __( 'generals', 'yaymail' ),
			'orderDetails'                                 => __( 'order Details', 'yaymail' ),
			'shippings'                                    => __( 'shippings', 'yaymail' ),
			'billings'                                     => __( 'billings', 'yaymail' ),
			'Vendor'                                       => __( 'Vendor', 'yaymail' ),
			'payments'                                     => __( 'payments', 'yaymail' ),
			'newusers'                                     => __( 'new users', 'yaymail' ),
			'resetpassword'                                => __( 'reset password', 'yaymail' ),
			'ORDERTAXES'                                   => __( 'ORDER TAXES', 'yaymail' ),
			'CUSTOMORDERMETA'                              => __( 'CUSTOM ORDER META', 'yaymail' ),
			'AUTOMATEWOO'                                  => __( 'AUTOMATEWOO', 'yaymail' ),
			'SendEmail'                                    => __( 'Send Email', 'yaymail' ),
			'Emailaddressfortest'                          => __( 'Email address for test', 'yaymail' ),
			'Emailsentsuccessfully'                        => __( 'Yay! Email sent successfully.', 'yaymail' ),
			'Tosendemailstoinboxwerecommend'               => __( 'To send emails to inbox, we recommend:', 'yaymail' ),
			'YaySMTPSimpleWPSMTPMail'                      => __( 'YaySMTP – Simple WP SMTP Mail', 'yaymail' ),
			'Details'                                      => __( 'Details', 'yaymail' ),
			'FreeInstallNow'                               => __( 'Free Install Now', 'yaymail' ),
			'Areyousureyouwanttoleave'                     => __( 'Are you sure you want to leave?', 'yaymail' ),
			'Leave'                                        => __( 'Leave', 'yaymail' ),
			'Copytemplate'                                 => __( 'Import template from', 'yaymail' ),
			'Import'                                       => __( 'Import', 'yaymail' ),
			'CopyFrom'                                     => __( 'Copy From', 'yaymail' ),
			'Areyousureyouwanttoresetthistemplate'         => __( 'Are you sure you want to reset this template?', 'yaymail' ),
			'Allchangesyoumadewontbesaved'                 => __( 'All changes you made won\'t be saved.', 'yaymail' ),
			'Preview'                                      => __( 'Preview', 'yaymail' ),
			'Emailpreview'                                 => __( 'Email preview', 'yaymail' ),
			'Desktoppreview'                               => __( 'Desktop preview', 'yaymail' ),
			'Mobilepreview'                                => __( 'Mobile preview', 'yaymail' ),
			'UpgradeTitle'                                 => __( 'Yay! You\'ve made the right choice!', 'yaymail' ),
			'GetYayMailPro'                                => __( 'Get YayMail Pro', 'yaymail' ),
			'Unlockfullfeaturesandpremiumsupport'          => __( 'Unlock full features and premium support', 'yaymail' ),
			'Undo&Redo'                                    => __( 'Undo & Redo', 'yaymail' ),
			'Getrecenteditingactionsandrevisions'          => __( 'Get recent editing actions and revisions', 'yaymail' ),
			'Compatiblewith20+third-partyplugins'          => __( 'Compatible with 20+ third-party plugins', 'yaymail' ),
			'CustomOrderStatus'                            => __( 'Custom Order Status', 'yaymail' ),
			'WooCommerceShipmentTracking'                  => __( 'WooCommerce Shipment Tracking', 'yaymail' ),
			'CheckoutFieldEditor'                          => __( 'Checkout Field Editor', 'yaymail' ),
			'WPML,Polylang,TranslatePress,and more!'       => __( 'WPML, Polylang, TranslatePress, and more!', 'yaymail' ),
			'BuyNow'                                       => __( 'Buy Now', 'yaymail' ),
			'SaveTemplate'                                 => __( 'Save template?', 'yaymail' ),
			'NoDontSave'                                   => __( 'No, don\'t save', 'yaymail' ),
			'DoYouWantToSaveBeforeMovingToAnotherTemplate' => __( 'Do you want to save before moving to another template?', 'yaymail' ),
			'EmailToShow'                                  => __( 'Email to show', 'yaymail' ),
			'ThisFeatureIsAvailableInYayMailPro'           => __( 'This feature is available in YayMail Pro', 'yaymail' ),
			'InputText'                                    => __( 'Input text', 'yaymail' ),
			'ImportText'                                   => __( 'Import text', 'yaymail' ),
			'TextPadding'                                  => __( 'Text padding', 'yaymail' ),
			'ImportPathUrl'                                => __( 'Import path url', 'yaymail' ),
			'RefreshPage'                                  => __( 'Refresh page?', 'yaymail' ),
			'GoPro'                                        => __( 'Go Pro', 'yaymail' ),
			'Blocks'                                       => __( 'Blocks', 'yaymail' ),
			'Elements'                                     => __( 'Elements', 'yaymail' ),
			'History'                                      => __( 'History', 'yaymail' ),
			'HappyWithYayMail'                             => __( 'Happy with YayMail', 'yaymail' ),
			'HappyWithYayMailReviewText'                   => __( 'Are you happy with YayMail? You can give a review to motivate our developers ', 'yaymail' ),
			'ReviewModalText'                              => __( 'All your saved template will be reset to default.', 'yaymail' ),
			'AlreadyDid'                                   => __( 'Already Did', 'yaymail' ),
			'RateNow'                                      => __( 'Rate Now', 'yaymail' ),
			'Padding'                                      => __( 'Padding', 'yaymail' ),
			'Top'                                          => __( 'Top', 'yaymail' ),
			'Left'                                         => __( 'Left', 'yaymail' ),
			'Right'                                        => __( 'Right', 'yaymail' ),
			'Bottom'                                       => __( 'Bottom', 'yaymail' ),
			'BackgroundColor'                              => __( 'Background color', 'yaymail' ),
			'TitleColor'                                   => __( 'Title color', 'yaymail' ),
			'TextColor'                                    => __( 'Text color', 'yaymail' ),
			'BorderColor'                                  => __( 'Border color', 'yaymail' ),
			'FontFamily'                                   => __( 'Font family', 'yaymail' ),
			'OrderItemTitle'                               => __( 'Order item title', 'yaymail' ),
			'ProductTitle'                                 => __( 'Product title', 'yaymail' ),
			'CostTitle'                                    => __( 'Cost title', 'yaymail' ),
			'QuantityTitle'                                => __( 'Quantity title', 'yaymail' ),
			'PriceTitle'                                   => __( 'Price title', 'yaymail' ),
			'SubtotalTitle'                                => __( 'Order item title', 'yaymail' ),
			'DiscountTitle'                                => __( 'Discount Title', 'yaymail' ),
			'PaymentMethodTitle'                           => __( 'Payment Method Title', 'yaymail' ),
			'TotalTitle'                                   => __( 'Total title', 'yaymail' ),
			'OrderFullyRefundedTitle'                      => __( 'Order fully refunded title', 'yaymail' ),
			'NoteTitle'                                    => __( 'Note title', 'yaymail' ),
			'ExpiresTitle'                                 => __( 'Expires title', 'yaymail' ),
			'DownloadTitle'                                => __( 'Download title', 'yaymail' ),
			'HeaderTitle'                                  => __( 'Header title', 'yaymail' ),
			'Title'                                        => __( 'Title', 'yaymail' ),
			'TitleSize'                                    => __( 'Title size', 'yaymail' ),
			'Subtitle'                                     => __( 'Subtitle', 'yaymail' ),
			'SubtitleSize'                                 => __( 'Subtitle size', 'yaymail' ),
			'BillingTitle'                                 => __( 'Billing title', 'yaymail' ),
			'ShippingTitle'                                => __( 'Shipping title', 'yaymail' ),
			'Type'                                         => __( 'Type', 'yaymail' ),
			'Align'                                        => __( 'Align', 'yaymail' ),
			'BorderWidth'                                  => __( 'Border width', 'yaymail' ),
			'BorderStyle'                                  => __( 'Border style', 'yaymail' ),
			'Solid'                                        => __( 'Solid', 'yaymail' ),
			'Dashed'                                       => __( 'Dashed', 'yaymail' ),
			'Dotted'                                       => __( 'Dotted', 'yaymail' ),
			'BorderRadius'                                 => __( 'Border radius', 'yaymail' ),
			'ProductType'                                  => __( 'Product type', 'yaymail' ),
			'SortedBy'                                     => __( 'Sorted by', 'yaymail' ),
			'Categories'                                   => __( 'Categories', 'yaymail' ),
			'Tags'                                         => __( 'Tags', 'yaymail' ),
			'Products'                                     => __( 'Products', 'yaymail' ),
			'NumberOfShowingProducts'                      => __( 'Number of showing products', 'yaymail' ),
			'ViewProducts'                                 => __( 'View products', 'yaymail' ),
			'Close'                                        => __( 'Close', 'yaymail' ),
			'NoProductFound'                               => __( 'NoProductFound', 'yaymail' ),
			'Image'                                        => __( 'Image', 'yaymail' ),
			'Name'                                         => __( 'Name', 'yaymail' ),
			'Price'                                        => __( 'Price', 'yaymail' ),
			'ChangeVideo'                                  => __( 'Change video', 'yaymail' ),
			'Newest'                                       => __( 'Newest', 'yaymail' ),
			'OnSale'                                       => __( 'On sale', 'yaymail' ),
			'Featured'                                     => __( 'Featured', 'yaymail' ),
			'CategorySelections'                           => __( 'Category selections', 'yaymail' ),
			'TagSelections'                                => __( 'Tag selections', 'yaymail' ),
			'ProductSelections'                            => __( 'Product selections', 'yaymail' ),
			'None'                                         => __( 'None', 'yaymail' ),
			'NameA-Z'                                      => __( 'Name A-Z', 'yaymail' ),
			'NameZ-A'                                      => __( 'Name Z-A', 'yaymail' ),
			'AscendingPrice'                               => __( 'Ascending price', 'yaymail' ),
			'DescendingPrice'                              => __( 'Descending price', 'yaymail' ),
			'Random'                                       => __( 'Random', 'yaymail' ),
			'ChangeImage'                                  => __( 'Change image', 'yaymail' ),
			'ImageURL'                                     => __( 'Image URL', 'yaymail' ),
			'URL'                                          => __( 'URL', 'yaymail' ),
			'Width'                                        => __( 'Width', 'yaymail' ),
			'Duplicate'                                    => __( 'Duplicate', 'yaymail' ),
			'CopyThisElementTo'                            => __( 'Copy this element to', 'yaymail' ),
			'Remove'                                       => __( 'Remove', 'yaymail' ),
			'YesSure'                                      => __( 'Yes, sure!', 'yaymail' ),
			'OpenMailbox'                                  => __( 'Open mailbox', 'yaymail' ),
			'CopyTemplateElement'                          => __( 'Copy template element', 'yaymail' ),
			'CopyTo'                                       => __( 'Copy to', 'yaymail' ),
			'CopyElement'                                  => __( 'Copy Element', 'yaymail' ),
			'ImportTemplate'                               => __( 'Import template', 'yaymail' ),
			'LoadingProducts'                              => __( 'Loading products', 'yaymail' ),
			'Blank'                                        => __( 'Blank', 'yaymail' ),
			'SendTestEmail'                                => __( 'Send test email', 'yaymail' ),
			'SelectTemplate'                               => __( 'Select template', 'yaymail' ),
			'AreYouSure'                                   => __( 'Are you sure?', 'yaymail' ),
			'Search'                                       => __( 'Search', 'yaymail' ),
			'Loading'                                      => __( 'Loading', 'yaymail' ),
			'ShowingItems'                                 => __( 'Showing items', 'yaymail' ),
			'TopContent'                                   => __( 'Top content', 'yaymail' ),
			'ProductPriceColor'                            => __( 'Product price color', 'yaymail' ),
			'ProductOriginalPriceColor'                    => __( 'Product original price color', 'yaymail' ),
			'BuyText'                                      => __( 'Buy text', 'yaymail' ),
			'BuyBackgroundColor'                           => __( 'Buy background color', 'yaymail' ),
			'BuyTextColor'                                 => __( 'Buy text color', 'yaymail' ),
			'NumberOfProductsPerRow'                       => __( 'Number of products per row', 'yaymail' ),
			'Content'                                      => __( 'Content', 'yaymail' ),
			'ButtonText'                                   => __( 'Button text', 'yaymail' ),
			'ButtonUrl'                                    => __( 'Button url', 'yaymail' ),
			'ButtonBackgroundColor'                        => __( 'Button background color', 'yaymail' ),
			'ButtonTextColor'                              => __( 'Button text color', 'yaymail' ),
			'ContentWidth'                                 => __( 'Content width', 'yaymail' ),
			'ContentAlign'                                 => __( 'Content align', 'yaymail' ),
			'BackgroundImage'                              => __( 'Background image', 'yaymail' ),
			'BackgroundRepeat'                             => __( 'Background repeat', 'yaymail' ),
			'ButtonAlign'                                  => __( 'Button align', 'yaymail' ),
			'FontSize'                                     => __( 'Font size', 'yaymail' ),
			'Height'                                       => __( 'Height', 'yaymail' ),
			'Weight'                                       => __( 'Weight', 'yaymail' ),
			'LineHeight'                                   => __( 'Line height', 'yaymail' ),
			'LineColor'                                    => __( 'Line color', 'yaymail' ),
			'LineType'                                     => __( 'Line type', 'yaymail' ),
			'WcHookOrderItem'                              => __( 'Wc hook order item', 'yaymail' ),
			'IconSpacing'                                  => __( 'Icon spacing', 'yaymail' ),
			'StylesTheme'                                  => __( 'Styles theme', 'yaymail' ),
			'TrackingDetails'                              => __( 'Tracking details', 'yaymail' ),
			'ImageOverlay'                                 => __( 'Image overlay', 'yaymail' ),
			'VideoUrl'                                     => __( 'Video url', 'yaymail' ),
			'ApplyToAllTemplates'                          => __( 'Apply to all templates', 'yaymail' ),
			'SetAsDefault'                                 => __( 'Set as default', 'yaymail' ),
			'BackgroundPosition'                           => __( 'Background position', 'yaymail' ),
			'Position'                                     => __( 'Position', 'yaymail' ),
			'Default'                                      => __( 'Default', 'yaymail' ),
			'Center'                                       => __( 'Center', 'yaymail' ),
			'Custom'                                       => __( 'Custom', 'yaymail' ),
			'Auto'                                         => __( 'Auto', 'yaymail' ),
			'Cover'                                        => __( 'Cover', 'yaymail' ),
			'Contain'                                      => __( 'Contain', 'yaymail' ),
			'Column'                                       => __( 'Column', 'yaymail' ),
			'ColumnWidth'                                  => __( 'Column width', 'yaymail' ),
			'HTMLCode'                                     => __( 'HTML code', 'yaymail' ),
			'ImportHTMLCode'                               => __( 'Import HTML code', 'yaymail' ),
			'SelectColumnNumber'                           => __( 'Select column number', 'yaymail' ),
			'Copy'                                         => __( 'Copy', 'yaymail' ),
			'CopyColumn'                                   => __( 'Copy column', 'yaymail' ),
			'Socials'                                      => __( 'Socials', 'yaymail' ),
			'BackgroundSize'                               => __( 'Background size', 'yaymail' ),
			'AddSocial'                                    => __( 'Add social', 'yaymail' ),
			'SelectSocial'                                 => __( 'Select social', 'yaymail' ),
			'Update'                                       => __( 'Update', 'yaymail' ),
			'SelectButtonNumber'                           => __( 'Select button number', 'yaymail' ),
			'SelectColumnNumber'                           => __( 'Select column number', 'yaymail' ),
			'TranslateIntegrationPriority'                 => __( 'Translate Integration Priority', 'yaymail' ),
			'SearchElement'                                => __( 'Search element', 'yaymail' ),
			'RecommendedAddonText'                         => __( 'This email template can be fully customized with YayMail Premium Addon.', 'yaymail' ),
			'UnavailableAddonBeforeText'                   => __( 'This email template is unavailable at the moment.', 'yaymail' ),
			'UnavailableAddonAfterText'                    => __( 'to see if it can be customized with', 'yaymail' ),
			'ContactUs'                                    => __( 'Contact us', 'yaymail' ),
			'EmailHeading'                                 => __( 'Email heading', 'yaymail' ),
			'ClearAll'                                     => __( 'Clear all', 'yaymail' ),
			'YouHaveNoRevision'                            => __( 'You have no revision.', 'yaymail' ),
			'SavedBy'                                      => __( 'saved by', 'yaymail' ),
			'DisableThisTemplate'                          => __( 'Disable this template', 'yaymail' ),
			'EnableThisTemplate'                           => __( 'Enable this template', 'yaymail' ),
			'MoveUp'                                       => __( 'Move up', 'yaymail' ),
			'MoveDown'                                     => __( 'Move down', 'yaymail' ),
			'Info'                                         => __( 'Info', 'yaymail' ),
			'Success'                                      => __( 'Success', 'yaymail' ),
			'Warning'                                      => __( 'Warning', 'yaymail' ),
			'Danger'                                       => __( 'Danger', 'yaymail' ),
			'Undo'                                         => __( 'Undo', 'yaymail' ),
			'Redo'                                         => __( 'Redo', 'yaymail' ),
			'PleaseSaveBeforeSendTest'                     => __( 'Please save before send test', 'yaymail' ),
			'ChangesYouMadeWillBeLost'                     => __( 'Changes you made will be lost.', 'yaymail' ),
			'Small'                                        => __( 'Small', 'yaymail' ),
			'Medium'                                       => __( 'Medium', 'yaymail' ),
			'Large'                                        => __( 'Large', 'yaymail' ),
			'XL'                                           => __( 'XL', 'yaymail' ),
			'XXL'                                          => __( 'XXL', 'yaymail' ),
			'Button'                                       => __( 'Button', 'yaymail' ),
			'Border'                                       => __( 'Border', 'yaymail' ),
			'Before'                                       => __( 'Before', 'yaymail' ),
			'After'                                        => __( 'After', 'yaymail' ),
			'ProductImage'                                 => __( 'Product image', 'yaymail' ),
			'ProductName'                                  => __( 'Product name', 'yaymail' ),
			'ProductPrice'                                 => __( 'Product price', 'yaymail' ),
			'ProductOriginalPrice'                         => __( 'Product original price', 'yaymail' ),
			'ProductPrice'                                 => __( 'Product price', 'yaymail' ),
			'BuyButton'                                    => __( 'Buy button', 'yaymail' ),
			'Edit'                                         => __( 'Edit', 'yaymail' ),
			'NoRepeat'                                     => __( 'No-repeat', 'yaymail' ),
			'Repeat'                                       => __( 'Repeat', 'yaymail' ),
			'RepeatX'                                      => __( 'Repeat-X', 'yaymail' ),
			'RepeatY'                                      => __( 'Repeat-Y', 'yaymail' ),
			'SolidDark'                                    => __( 'Solid Dark', 'yaymail' ),
			'Colorful'                                     => __( 'Colorful', 'yaymail' ),
			'LineDark'                                     => __( 'Line Dark', 'yaymail' ),
			'SolidLight'                                   => __( 'Solid Light', 'yaymail' ),
			'LineLight'                                    => __( 'Line Light', 'yaymail' ),
			'Color'                                        => __( 'Color', 'yaymail' ),
			'MediaImageLibrary'                            => __( 'Media Image Library', 'yaymail' ),
			'SelectAMedia'                                 => __( 'Select a media', 'yaymail' ),
			'UseThisImage'                                 => __( 'Use this image', 'yaymail' ),
			'UseThisVideo'                                 => __( 'Use this video', 'yaymail' ),
			'ACTIONS'                                      => __( 'ACTIONS', 'yaymail' ),
			'REVISIONS'                                    => __( 'REVISIONS', 'yaymail' ),
			'SaveAnyway'                                   => __( 'Save anyway', 'yaymail' ),
			'InvalidConditionText'                         => __( 'There are invalid values in your conditions, they will be removed when you proceed to save', 'yaymail' ),
		);
	}
}
